# 🔐 Login System Setup & Testing Guide

This guide will help you set up and test the login system for all user roles in Flex Market.

## 🚀 Quick Setup (3 Steps)

### Step 1: Generate Password Hashes
Run this command to generate fresh password hashes:
```bash
php generate_password_hashes.php
```

This will output SQL UPDATE statements with fresh password hashes.

### Step 2: Run the SQL Script
Execute the SQL script to create all dummy users:

**Option A: Via phpMyAdmin**
1. Open phpMyAdmin (http://localhost/phpmyadmin)
2. Select your database (e.g., `flex_market`)
3. Click "SQL" tab
4. Copy and paste the contents of `create_dummy_users.sql`
5. Click "Go"

**Option B: Via Command Line**
```bash
mysql -u root -p flex_market < create_dummy_users.sql
```

### Step 3: Verify Setup
Run the diagnostic script:
```bash
php check_login_system.php
```

This will check:
- ✓ Database table structure
- ✓ Dummy users exist
- ✓ Passwords are correctly hashed
- ✓ Routes are configured
- ✓ Session is working
- ✓ AuthFilter exists

## 🧪 Testing Login

### Test Each User Role

**1. Super Admin Login**
- URL: http://localhost:8080/login
- Email: `superadmin@flex.com`
- Password: `Super@123`
- Should redirect to: `/superadmin/dashboard`

**2. Admin Login**
- URL: http://localhost:8080/login
- Email: `admin@flex.com`
- Password: `Admin@123`
- Should redirect to: `/admin/dashboard`

**3. Seller Login**
- URL: http://localhost:8080/login
- Email: `seller@flex.com`
- Password: `Seller@123`
- Should redirect to: `/seller/dashboard`

**4. Delivery Login**
- URL: http://localhost:8080/login
- Email: `delivery@flex.com`
- Password: `Delivery@123`
- Should redirect to: `/delivery/dashboard`

**5. Buyer Login**
- URL: http://localhost:8080/login
- Email: `buyer@flex.com`
- Password: `Buyer@123`
- Should redirect to: `/buyer` (browse products)

## 🔍 Troubleshooting Common Issues

### Issue 1: "Invalid email or password"

**Possible Causes:**
1. Password hash mismatch
2. User not verified
3. User doesn't exist

**Solutions:**
```sql
-- Check if user exists
SELECT id, email, role, is_verified, password FROM users WHERE email = 'superadmin@flex.com';

-- If user exists but password doesn't work, regenerate hash:
-- Run generate_password_hashes.php and use the output

-- Make sure user is verified
UPDATE users SET is_verified = 1 WHERE email = 'superadmin@flex.com';
```

### Issue 2: "Please login first" after successful login

**Possible Causes:**
1. Session not persisting
2. Role/user_type mismatch

**Solutions:**
```sql
-- Check user role
SELECT id, email, user_type, role FROM users WHERE email = 'superadmin@flex.com';

-- Fix role if needed
UPDATE users SET role = 'super_admin' WHERE email = 'superadmin@flex.com';
UPDATE users SET role = 'admin' WHERE email = 'admin@flex.com';
UPDATE users SET role = 'seller' WHERE email = 'seller@flex.com';
UPDATE users SET role = 'delivery' WHERE email = 'delivery@flex.com';
UPDATE users SET role = 'buyer' WHERE email = 'buyer@flex.com';
```

Check session configuration in `app/Config/Session.php`:
```php
// Make sure these settings are correct
public string $driver = 'CodeIgniter\Session\Handlers\FileHandler';
public string $savePath = WRITEPATH . 'session';
```

### Issue 3: Database columns missing

**Solution:**
```sql
-- Add missing columns if they don't exist
ALTER TABLE users ADD COLUMN IF NOT EXISTS role VARCHAR(50) DEFAULT NULL;
ALTER TABLE users ADD COLUMN IF NOT EXISTS password VARCHAR(255) DEFAULT NULL;
ALTER TABLE users ADD COLUMN IF NOT EXISTS reliability_score INT(11) DEFAULT 0;
ALTER TABLE users ADD COLUMN IF NOT EXISTS is_blocked TINYINT(1) DEFAULT 0;
ALTER TABLE users ADD COLUMN IF NOT EXISTS bgv_cleared TINYINT(1) DEFAULT 0;
ALTER TABLE users ADD COLUMN IF NOT EXISTS is_verified TINYINT(1) DEFAULT 0;
```

### Issue 4: Login page not loading

**Check:**
1. Server is running: `php spark serve`
2. URL is correct: http://localhost:8080/login
3. Check logs: `writable/logs/log-YYYY-MM-DD.log`

### Issue 5: CSRF token mismatch

**Solution:**
Clear session and cookies:
```bash
# Delete session files
rm -rf writable/session/*

# Or in Windows PowerShell:
Remove-Item writable\session\* -Force
```

## 📋 Login Flow Verification Checklist

- [ ] Login page loads at `/login`
- [ ] Login form shows email and password fields
- [ ] CSRF token is present in form
- [ ] Submit button works
- [ ] Error messages display correctly
- [ ] Success login redirects to correct dashboard
- [ ] Session persists across page loads
- [ ] Protected routes require login
- [ ] Logout clears session
- [ ] Each role can access their dashboard

## 🎯 Next Steps After Login Works

1. **Test Role-Based Access Control**
   - Try accessing admin routes as seller (should be blocked)
   - Try accessing seller routes as buyer (should be blocked)

2. **Test Features**
   - Super Admin: Create/delete admins
   - Admin: Approve products, assign delivery
   - Seller: Upload products, manage offers
   - Delivery: Accept delivery requests
   - Buyer: Browse products, make offers

3. **Test Complete Workflow**
   - Seller uploads product
   - Admin approves product
   - Buyer makes offer
   - Seller accepts offer
   - Admin assigns delivery
   - Delivery person completes delivery

## 📞 Need Help?

If you're still having issues after following this guide:

1. Run the diagnostic script: `php check_login_system.php`
2. Check error logs in `writable/logs/`
3. Enable debug mode in `app/Config/Boot/development.php`
4. Check browser console for JavaScript errors
5. Check network tab in browser DevTools

## 🔐 All Test Credentials (Quick Reference)

| Role | Email | Password | Dashboard URL |
|------|-------|----------|---------------|
| Super Admin | superadmin@flex.com | Super@123 | /superadmin/dashboard |
| Admin | admin@flex.com | Admin@123 | /admin/dashboard |
| Seller | seller@flex.com | Seller@123 | /seller/dashboard |
| Delivery | delivery@flex.com | Delivery@123 | /delivery/dashboard |
| Buyer | buyer@flex.com | Buyer@123 | /buyer |

**Login URL:** http://localhost:8080/login

---

Last Updated: January 10, 2026
