<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Orders - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
</head>
<body>
<div class="container mt-4">
    <h3>All Orders</h3>
    
    <div class="mb-3">
        <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-outline-secondary">Back to Dashboard</a>
    </div>

    <?php if (!empty($orders)): ?>
        <table class="table table-hover">
            <thead>
            <tr>
                <th>ID</th>
                <th>Product</th>
                <th>Buyer</th>
                <th>Seller</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Date</th>
                <th>Action</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($orders as $order): ?>
                <tr>
                    <td>#<?= $order['id'] ?></td>
                    <td><?= esc($order['product_title'] ?? 'N/A') ?></td>
                    <td><?= esc($order['buyer_name'] ?? 'N/A') ?></td>
                    <td><?= esc($order['seller_name'] ?? 'N/A') ?></td>
                    <td>₹<?= number_format($order['final_price'] ?? 0) ?></td>
                    <td><?= ucwords(str_replace('_', ' ', $order['status'] ?? '')) ?></td>
                    <td><?= isset($order['created_at']) ? date('d M Y', strtotime($order['created_at'])) : '-' ?></td>
                    <td>
                        <?php if (($order['status'] ?? '') === 'confirmed'): ?>
                            <button class="btn btn-sm btn-primary" onclick="assignDelivery(<?= $order['id'] ?>)">Assign Delivery</button>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <div class="alert alert-info">No orders found.</div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function assignDelivery(orderId) {
    fetch('/admin/available-delivery-persons')
        .then(r => r.json())
        .then(data => {
            if (!data.delivery_persons || data.delivery_persons.length === 0) {
                alert('No delivery persons available');
                return;
            }
            const dp = data.delivery_persons[0];
            if (confirm('Assign to ' + dp.name + '?')) {
                fetch('/admin/assign-delivery/' + orderId, {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({delivery_person_id: dp.user_id})
                }).then(r => r.json()).then(j => {
                    alert(j.message || 'Assigned');
                    location.reload();
                });
            }
        });
}
</script>
</body>
</html>
