<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Offers - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px 0;
        }
        .container {
            max-width: 1200px;
        }
        .page-header {
            background: white;
            padding: 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
        }
        .page-header h1 {
            color: #764ba2;
            font-weight: 600;
            margin: 0;
        }
        .filter-tabs {
            background: white;
            padding: 20px;
            border-radius: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
        }
        .nav-pills .nav-link {
            border-radius: 10px;
            padding: 10px 20px;
            font-weight: 500;
            color: #764ba2;
        }
        .nav-pills .nav-link.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .offer-card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            transition: all 0.3s;
        }
        .offer-card:hover {
            box-shadow: 0 5px 25px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }
        .product-image {
            width: 100px;
            height: 100px;
            object-fit: cover;
            border-radius: 10px;
        }
        .status-badge {
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
        }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-accepted { background: #d1e7dd; color: #0f5132; }
        .status-rejected { background: #f8d7da; color: #842029; }
        .offer-details {
            display: flex;
            gap: 15px;
            align-items: start;
        }
        .offer-info {
            flex: 1;
        }
        .offer-info h5 {
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 10px;
        }
        .offer-meta {
            color: #6c757d;
            font-size: 0.9rem;
            margin-bottom: 5px;
        }
        .price-info {
            text-align: right;
        }
        .price-amount {
            font-size: 1.3rem;
            color: #764ba2;
            font-weight: 600;
        }
        .btn-cancel {
            background: #dc3545;
            color: white;
            border: none;
            padding: 6px 16px;
            border-radius: 8px;
            font-size: 0.85rem;
            font-weight: 500;
            margin-top: 10px;
        }
        .btn-cancel:hover {
            background: #c82333;
        }
        .btn-view {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 10px;
            font-weight: 500;
        }
        .empty-state {
            background: white;
            padding: 60px 20px;
            border-radius: 15px;
            text-align: center;
        }
        .empty-state i {
            font-size: 4rem;
            color: #ddd;
            margin-bottom: 20px;
        }
        .seller-info {
            background: #f8f9fa;
            padding: 10px 15px;
            border-radius: 8px;
            margin-top: 10px;
            font-size: 0.9rem;
        }
        .reliability-score {
            display: inline-block;
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-left: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1><i class="bi bi-tag"></i> My Offers</h1>
                    <p class="text-muted mb-0">Track offers you've sent to sellers</p>
                </div>
                <a href="<?= base_url('buyer') ?>" class="btn btn-view">
                    <i class="bi bi-arrow-left"></i> Back to Browse
                </a>
            </div>
        </div>

        <!-- Filter Tabs -->
        <div class="filter-tabs">
            <ul class="nav nav-pills" id="statusTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" data-filter="all" onclick="filterOffers('all')">
                        All Offers (<?= count($offers ?? []) ?>)
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" data-filter="pending" onclick="filterOffers('pending')">
                        Pending (<?= count(array_filter($offers ?? [], fn($o) => $o['status'] === 'pending')) ?>)
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" data-filter="accepted" onclick="filterOffers('accepted')">
                        Accepted (<?= count(array_filter($offers ?? [], fn($o) => $o['status'] === 'accepted')) ?>)
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" data-filter="rejected" onclick="filterOffers('rejected')">
                        Rejected (<?= count(array_filter($offers ?? [], fn($o) => $o['status'] === 'rejected')) ?>)
                    </button>
                </li>
            </ul>
        </div>

        <!-- Offers List -->
        <div id="offersContainer">
            <?php if (empty($offers)): ?>
                <div class="empty-state">
                    <i class="bi bi-inbox"></i>
                    <h4>No Offers Yet</h4>
                    <p class="text-muted">Start making offers on products you like</p>
                    <a href="<?= base_url('buyer') ?>" class="btn btn-view">Browse Products</a>
                </div>
            <?php else: ?>
                <?php foreach ($offers as $offer): ?>
                    <div class="offer-card" data-status="<?= esc($offer['status']) ?>">
                        <div class="offer-details">
                            <img src="<?= esc($offer['product_image'] ?? '/images/no-image.jpg') ?>" 
                                 alt="Product" 
                                 class="product-image">
                            
                            <div class="offer-info">
                                <h5><?= esc($offer['product_title']) ?></h5>
                                
                                <div class="offer-meta">
                                    <i class="bi bi-tag"></i> 
                                    <?= ucfirst(esc($offer['offer_type'])) ?> Offer
                                </div>
                                
                                <div class="offer-meta">
                                    <i class="bi bi-shop"></i> 
                                    Seller: <?= esc($offer['seller_name']) ?>
                                    <span class="reliability-score">
                                        <i class="bi bi-star-fill"></i> <?= number_format($offer['seller_reliability_score'] ?? 0, 1) ?>
                                    </span>
                                </div>
                                
                                <div class="offer-meta">
                                    <i class="bi bi-calendar"></i> 
                                    Sent: <?= date('d M Y, h:i A', strtotime($offer['created_at'])) ?>
                                </div>

                                <?php if ($offer['offer_type'] === 'rent' && !empty($offer['rental_start_date'])): ?>
                                    <div class="offer-meta">
                                        <i class="bi bi-calendar-range"></i> 
                                        Rental Period: <?= date('d M', strtotime($offer['rental_start_date'])) ?> - 
                                        <?= date('d M Y', strtotime($offer['rental_end_date'])) ?>
                                        <span class="badge bg-info ms-2">
                                            <?php 
                                            $start = new DateTime($offer['rental_start_date']);
                                            $end = new DateTime($offer['rental_end_date']);
                                            $days = $start->diff($end)->days + 1;
                                            echo $days . ' day' . ($days > 1 ? 's' : '');
                                            ?>
                                        </span>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($offer['message'])): ?>
                                    <div class="seller-info">
                                        <i class="bi bi-chat-left-text"></i>
                                        <strong>Your Message:</strong> <?= esc($offer['message']) ?>
                                    </div>
                                <?php endif; ?>

                                <div class="mt-2">
                                    <span class="status-badge status-<?= esc($offer['status']) ?>">
                                        <?= ucfirst(esc($offer['status'])) ?>
                                    </span>
                                </div>
                            </div>

                            <div class="price-info">
                                <div class="price-amount">₹<?= number_format($offer['offered_price'] ?? 0, 2) ?></div>
                                <div class="text-muted" style="font-size: 0.85rem;">Your Offer</div>
                                
                                <?php if ($offer['offer_type'] === 'rent' && !empty($offer['deposit_amount'])): ?>
                                    <div class="text-muted mt-2" style="font-size: 0.9rem;">
                                        Deposit: ₹<?= number_format($offer['deposit_amount'], 2) ?>
                                    </div>
                                <?php endif; ?>

                                <?php if ($offer['status'] === 'pending'): ?>
                                    <button class="btn btn-cancel" onclick="cancelOffer(<?= $offer['id'] ?>)">
                                        <i class="bi bi-x-circle"></i> Cancel
                                    </button>
                                <?php endif; ?>

                                <?php if ($offer['status'] === 'accepted'): ?>
                                    <div class="alert alert-success mt-2 mb-0" style="font-size: 0.85rem; padding: 8px;">
                                        <i class="bi bi-check-circle-fill"></i> Seller accepted!
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function filterOffers(status) {
            // Update active tab
            document.querySelectorAll('.nav-link').forEach(link => {
                link.classList.remove('active');
            });
            event.target.classList.add('active');

            // Filter offer cards
            document.querySelectorAll('.offer-card').forEach(card => {
                if (status === 'all' || card.dataset.status === status) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
        }

        function cancelOffer(offerId) {
            if (!confirm('Are you sure you want to cancel this offer?')) {
                return;
            }

            fetch('/buyer/cancel-offer/' + offerId, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Offer cancelled successfully');
                    location.reload();
                } else {
                    alert(data.message || 'Failed to cancel offer');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred');
            });
        }
    </script>
</body>
</html>
