<?= $this->extend('delivery/layout') ?>

<?= $this->section('content') ?>

<div class="max-w-4xl">
    <div class="mb-8">
        <div class="bg-yellow-50 border-l-4 border-yellow-400 p-6 rounded-r-xl">
            <div class="flex items-start">
                <span class="text-4xl mr-4">⚠️</span>
                <div>
                    <h2 class="text-2xl font-bold text-yellow-800 mb-2">Access Restricted</h2>
                    <p class="text-yellow-700">Complete the requirements below to start accepting delivery requests.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
        <!-- KYC Status -->
        <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-lg transition">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                    <span class="text-2xl mr-2">📄</span> KYC Verification
                </h3>
                <?php if ($kycStatus == 1): ?>
                    <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">✓ Verified</span>
                <?php else: ?>
                    <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-sm font-medium">⏳ Pending</span>
                <?php endif; ?>
            </div>
            <p class="text-gray-600 text-sm mb-4">
                <?php if ($kycStatus == 1): ?>
                    Your KYC documents have been verified by admin.
                <?php else: ?>
                    Please submit your PAN and Aadhar card details for verification.
                <?php endif; ?>
            </p>
            <?php if ($kycStatus != 1): ?>
                <a href="<?= base_url('delivery/profile') ?>" class="inline-block px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition font-medium">
                    Complete KYC →
                </a>
            <?php endif; ?>
        </div>

        <!-- BGV Status -->
        <div class="bg-white rounded-xl shadow-md p-6 hover:shadow-lg transition">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-800 flex items-center">
                    <span class="text-2xl mr-2">🛡️</span> Background Verification
                </h3>
                <?php if ($bgvStatus == 1): ?>
                    <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">✓ Cleared</span>
                <?php else: ?>
                    <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-sm font-medium">⏳ In Progress</span>
                <?php endif; ?>
            </div>
            <p class="text-gray-600 text-sm mb-4">
                <?php if ($bgvStatus == 1): ?>
                    Your background verification has been completed successfully.
                <?php else: ?>
                    Admin is reviewing your background verification. This process usually takes 24-48 hours.
                <?php endif; ?>
            </p>
            <?php if ($bgvStatus != 1): ?>
                <p class="text-gray-500 text-sm italic">⏱️ Automated process - no action required</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Profile Details Card -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
            <span class="text-2xl mr-2">👤</span> Your Profile
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                <span class="text-gray-600 font-medium">Name</span>
                <span class="font-semibold text-gray-900"><?= esc($user['name']) ?></span>
            </div>
            <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                <span class="text-gray-600 font-medium">Email</span>
                <span class="font-semibold text-gray-900"><?= esc($user['email']) ?></span>
            </div>
            <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                <span class="text-gray-600 font-medium">Mobile</span>
                <span class="font-semibold text-gray-900"><?= esc($user['mobile']) ?></span>
            </div>
            <?php if ($deliveryPerson): ?>
                <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                    <span class="text-gray-600 font-medium">Vehicle Type</span>
                    <span class="font-semibold text-gray-900"><?= ucfirst($deliveryPerson['vehicle_type'] ?? 'Not set') ?></span>
                </div>
                <div class="flex justify-between p-3 bg-gray-50 rounded-lg">
                    <span class="text-gray-600 font-medium">Badge Count</span>
                    <span class="font-semibold text-purple-600">🏆 <?= esc($deliveryPerson['badges'] ?? 0) ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Next Steps -->
    <div class="bg-blue-50 border border-blue-200 rounded-xl p-6">
        <h3 class="text-lg font-semibold text-blue-900 mb-4 flex items-center">
            <span class="text-2xl mr-2">📋</span> Next Steps
        </h3>
        <ol class="list-decimal list-inside space-y-3 text-blue-800">
            <?php if ($kycStatus != 1): ?>
                <li class="flex items-start">
                    <span class="mr-2">1.</span>
                    <span>Complete your KYC verification by uploading PAN and Aadhar details in the <a href="<?= base_url('delivery/profile') ?>" class="underline font-medium">Profile section</a></span>
                </li>
            <?php endif; ?>
            <?php if ($bgvStatus != 1): ?>
                <li class="flex items-start">
                    <span class="mr-2"><?= $kycStatus != 1 ? '2' : '1' ?>.</span>
                    <span>Wait for admin to complete your background verification (24-48 hours)</span>
                </li>
            <?php endif; ?>
            <li class="flex items-start">
                <span class="mr-2"><?= ($kycStatus != 1 && $bgvStatus != 1) ? '3' : (($kycStatus != 1 || $bgvStatus != 1) ? '2' : '1') ?>.</span>
                <span>Once both are complete, you'll be able to view and accept delivery requests from this dashboard</span>
            </li>
        </ol>
    </div>
</div>

<?= $this->endSection() ?>
