<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Delivery Dashboard' ?> - Flex Market</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .sidebar-fixed { position: fixed; left: 0; top: 0; bottom: 0; width: 260px; }
        .content-area { margin-left: 260px; min-height: 100vh; }
        .nav-item.active { background: rgba(255,255,255,0.1); border-left: 4px solid white; }
        .badge-gold { background: linear-gradient(135deg, #FFD700, #FFA500); }
    </style>
</head>
<body class="bg-gray-50">
    
    <!-- Sidebar -->
    <aside class="sidebar-fixed bg-gradient-to-b from-purple-900 to-purple-700 text-white overflow-y-auto shadow-2xl">
        <div class="p-6">
            <!-- Logo & Brand -->
            <div class="flex items-center space-x-3 mb-8 pb-6 border-b border-purple-600">
                <div class="w-12 h-12 bg-white rounded-xl flex items-center justify-center">
                    <span class="text-3xl">🚚</span>
                </div>
                <div>
                    <h1 class="text-xl font-bold">Flex Delivery</h1>
                    <p class="text-purple-300 text-xs">Partner Portal</p>
                </div>
            </div>

            <!-- User Info Card -->
            <div class="bg-purple-800 bg-opacity-50 rounded-lg p-4 mb-6">
                <div class="flex items-center space-x-3 mb-3">
                    <div class="w-12 h-12 bg-purple-600 rounded-full flex items-center justify-center font-bold text-lg">
                        <?= strtoupper(substr(session()->get('user_name') ?? 'D', 0, 1)) ?>
                    </div>
                    <div class="flex-1">
                        <p class="font-semibold text-sm"><?= esc(session()->get('user_name')) ?></p>
                        <p class="text-purple-300 text-xs"><?= esc(session()->get('email')) ?></p>
                    </div>
                </div>
                <?php
                $deliveryPerson = isset($deliveryPerson) ? $deliveryPerson : null;
                $badgeCount = $deliveryPerson['badges'] ?? 0;
                $rating = $deliveryPerson['rating'] ?? 0;
                ?>
                <div class="flex items-center justify-between text-xs">
                    <div class="flex items-center space-x-1">
                        <span>⭐</span>
                        <span><?= number_format($rating, 1) ?></span>
                    </div>
                    <div class="badge-gold px-3 py-1 rounded-full font-semibold text-purple-900">
                        🏆 <?= $badgeCount ?> Badges
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="space-y-1">
                <a href="<?= base_url('delivery/dashboard') ?>" 
                   class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-purple-800 transition <?= (uri_string() == 'delivery/dashboard') ? 'active' : '' ?>">
                    <span class="text-xl">📊</span>
                    <span class="font-medium">Dashboard</span>
                </a>
                
                <a href="<?= base_url('delivery/profile') ?>" 
                   class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-purple-800 transition <?= (uri_string() == 'delivery/profile') ? 'active' : '' ?>">
                    <span class="text-xl">👤</span>
                    <span class="font-medium">Profile & KYC</span>
                </a>
                
                <a href="<?= base_url('delivery/history') ?>" 
                   class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-purple-800 transition <?= (uri_string() == 'delivery/history') ? 'active' : '' ?>">
                    <span class="text-xl">📜</span>
                    <span class="font-medium">Delivery History</span>
                </a>
                
                <a href="<?= base_url('delivery/earnings') ?>" 
                   class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-purple-800 transition <?= (uri_string() == 'delivery/earnings') ? 'active' : '' ?>">
                    <span class="text-xl">💰</span>
                    <span class="font-medium">Earnings</span>
                </a>

                <div class="border-t border-purple-600 my-4"></div>

                <a href="<?= base_url('auth/logout') ?>" 
                   class="nav-item flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-red-700 transition text-red-200">
                    <span class="text-xl">🚪</span>
                    <span class="font-medium">Logout</span>
                </a>
            </nav>
        </div>
    </aside>

    <!-- Main Content Area -->
    <main class="content-area">
        <!-- Top Header -->
        <header class="bg-white shadow-sm sticky top-0 z-10">
            <div class="px-8 py-4 flex items-center justify-between">
                <div>
                    <h2 class="text-2xl font-bold text-gray-800"><?= $pageTitle ?? 'Dashboard' ?></h2>
                    <p class="text-gray-500 text-sm"><?= $pageSubtitle ?? 'Welcome back!' ?></p>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-sm text-gray-600"><?= date('l, F j, Y') ?></span>
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <div class="p-8">
            <?php if (session()->getFlashdata('success')): ?>
                <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg">
                    <?= session()->getFlashdata('success') ?>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('error')): ?>
                <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg">
                    <?= session()->getFlashdata('error') ?>
                </div>
            <?php endif; ?>

            <?= $this->renderSection('content') ?>
        </div>
    </main>

</body>
</html>
