<aside class="fixed left-0 top-16 bottom-0 w-64 bg-purple-800 text-white overflow-y-auto">
    <nav class="p-4">
        <div class="mb-6">
            <div class="flex items-center space-x-2 mb-2">
                <span class="text-2xl">🚚</span>
                <span class="text-sm font-semibold"><?= esc(session()->get('user_name')) ?></span>
            </div>
            <p class="text-purple-200 text-xs"><?= esc(session()->get('email')) ?></p>
            <?php 
            $role = session()->get('role') ?: session()->get('user_type');
            $badgeCount = 0; // Will be passed from controller if needed
            ?>
            <div class="mt-2 flex items-center space-x-2">
                <span class="px-2 py-1 bg-purple-700 rounded text-xs font-medium">
                    <?= $badgeCount ?> Badges
                </span>
            </div>
        </div>

        <ul class="space-y-2">
            <li>
                <a href="<?= base_url('delivery/dashboard') ?>" 
                   class="flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-purple-700 transition
                   <?= (uri_string() == 'delivery/dashboard') ? 'bg-purple-700' : '' ?>">
                    <span>📊</span>
                    <span>Dashboard</span>
                </a>
            </li>
            <li>
                <a href="<?= base_url('delivery/profile') ?>" 
                   class="flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-purple-700 transition
                   <?= (uri_string() == 'delivery/profile') ? 'bg-purple-700' : '' ?>">
                    <span>👤</span>
                    <span>Profile & KYC</span>
                </a>
            </li>
            <li>
                <a href="<?= base_url('delivery/history') ?>" 
                   class="flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-purple-700 transition
                   <?= (uri_string() == 'delivery/history') ? 'bg-purple-700' : '' ?>">
                    <span>📜</span>
                    <span>Delivery History</span>
                </a>
            </li>
            <li>
                <a href="<?= base_url('delivery/earnings') ?>" 
                   class="flex items-center space-x-3 px-4 py-3 rounded-lg hover:bg-purple-700 transition
                   <?= (uri_string() == 'delivery/earnings') ? 'bg-purple-700' : '' ?>">
                    <span>💰</span>
                    <span>Earnings</span>
                </a>
            </li>
        </ul>
    </nav>
</aside>
