<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notifications - Flex Market</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
    <h3>Notifications</h3>
    
    <?php if (!empty($notifications)): ?>
        <?php foreach ($notifications as $notif): ?>
            <div class="alert alert-<?= $notif['is_read'] ? 'secondary' : 'primary' ?>">
                <strong><?= esc($notif['title']) ?></strong><br>
                <small><?= esc($notif['message']) ?></small><br>
                <small class="text-muted"><?= date('d M Y H:i', strtotime($notif['created_at'])) ?></small>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="alert alert-info">No notifications</div>
    <?php endif; ?>
    
    <a href="<?= base_url('seller/dashboard') ?>" class="btn btn-secondary">Back</a>
</div>
</body>
</html>
