<?php
/**
 * Generate Password Hashes for Dummy Users
 * This script generates the correct password hashes for all test users
 */

// Define test passwords
$passwords = [
    'Super@123'    => 'Super Admin',
    'Admin@123'    => 'Admin',
    'Seller@123'   => 'Seller',
    'Delivery@123' => 'Delivery',
    'Buyer@123'    => 'Buyer'
];

echo "=== PASSWORD HASHES FOR DUMMY USERS ===\n\n";

foreach ($passwords as $password => $role) {
    $hash = password_hash($password, PASSWORD_DEFAULT);
    echo "Role: {$role}\n";
    echo "Password: {$password}\n";
    echo "Hash: {$hash}\n";
    echo str_repeat("-", 80) . "\n\n";
}

// Test verification
echo "\n=== VERIFICATION TEST ===\n";
$testPassword = 'Super@123';
$testHash = password_hash($testPassword, PASSWORD_DEFAULT);
echo "Test Password: {$testPassword}\n";
echo "Test Hash: {$testHash}\n";
echo "Verification: " . (password_verify($testPassword, $testHash) ? "✓ PASS" : "✗ FAIL") . "\n";

echo "\n=== SQL UPDATE STATEMENTS ===\n";
echo "Copy and paste these into your database:\n\n";

$users = [
    ['email' => 'superadmin@flex.com', 'password' => 'Super@123'],
    ['email' => 'admin@flex.com', 'password' => 'Admin@123'],
    ['email' => 'seller@flex.com', 'password' => 'Seller@123'],
    ['email' => 'delivery@flex.com', 'password' => 'Delivery@123'],
    ['email' => 'buyer@flex.com', 'password' => 'Buyer@123']
];

foreach ($users as $user) {
    $hash = password_hash($user['password'], PASSWORD_DEFAULT);
    echo "UPDATE users SET password = '{$hash}' WHERE email = '{$user['email']}';\n";
}
